<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
if(!earis_login()){
    header("Location: ".EAR_PATH."index.php/login");
    exit;
}

$filename = isset($_POST["filename"])?trim($_POST["filename"]):false;
$session = isset($_POST["session"])?trim($_POST["session"]):false;
$start = isset($_POST["start"])?intval($_POST["start"]):false;
$size = isset($_POST["size"])?trim($_POST["size"]):false;
$ext = pathinfo($filename, PATHINFO_EXTENSION);

if($filename == false || !in_array($ext, array("apk", "ipa"))){
    die("Error: Invalid Filename");
}
if($session == false || $session == false){
    die("Error: session not found");
}
$session = md5($session.session_id());

if($size > EAR_MAXSIZE){
    die("Error: Size limit ".EAR_MAXSIZE);
}

$file = EAR_TMP.DS.$session.".json";
$dir = EAR_TMP.DS.$session;
try{
    if($start === -1){
        $appdetail = isset($_POST["appdetail"])?trim($_POST["appdetail"]):false;
        if($appdetail == false || !is_json($appdetail)){
            throw new Exception("Invalid APP detail (tmp)");
        }
        
        if(!file_exists($dir) && !mkdir($dir, 0777, true)){
            throw new Exception("Make app dir failed (tmp)");
        }
        if(!file_put_contents($file, $appdetail)){
            throw new Exception("Save APP detail failed (tmp)");
        }
        die("0");
    }else{
        if(!is_dir($dir)){
            throw new Exception("App dir not found (tmp)");
        }
        if (!isset($_FILES['appfile'])){
            throw new Exception("Appfile not found (tmp)");
        }
        if ($start+$_FILES['appfile']['size'] > EAR_MAXSIZE){
            throw new Exception("Size limit ".EAR_MAXSIZE." (tmp)");
        }
        $saveto = $dir.DS.$start.".part";
        if(!move_uploaded_file($_FILES['appfile']['tmp_name'], $saveto)){
            throw new Exception("Move app failed (tmp)");
        }
        if($start+$_FILES['appfile']['size'] < $size){
            die("0");
        }else{
            $appfile = $dir.DS."app.{$ext}";
            $parts = glob($dir.DS."*.part");
            if($parts == false){
                throw new Exception("Appfiles not found (tmp)");
            }
            usort($parts, function($a, $b){
                return intval(basename($a)) > intval(basename($b));
            });
            foreach($parts as $part){
                $c = file_get_contents($part);
                if(!file_put_contents($appfile, $c, FILE_APPEND)){
                    throw new Exception("Save APP failed (tmp)");
                }
                unlink($part);
            }
            
            $appdetail = json_decode(file_get_contents($file), true);
            if($appdetail == false){
                throw new Exception("Get APP detail failed (tmp)");
            }
            $email = $_SESSION["user"]["email"];
            $icon = isset($appdetail["icon"])?trim($appdetail["icon"]):"";
            $displayname = isset($appdetail["displayname"])?trim($appdetail["displayname"]):"";
            $version = isset($appdetail["version"])?trim($appdetail["version"]):"";
            $packagename = isset($appdetail["packagename"])?trim($appdetail["packagename"]):"";
            $mnvs = isset($appdetail["mnvs"])?trim($appdetail["mnvs"]):"";
            $bid = isset($appdetail["bid"])?trim($appdetail["bid"]):"";
            $bsvs = isset($appdetail["bsvs"])?trim($appdetail["bsvs"]):"";
            $bvs = isset($appdetail["bvs"])?trim($appdetail["bvs"]):"";
            $app = new App();
            $uuid = $app->add($email, $appfile, $filename, $icon, $displayname, $version, $packagename, $mnvs, $bid, $bsvs, $bvs);
            if(!$uuid){
                throw new Exception("Upload APP failed");
            }
            
            if(file_exists($file)){
                unlink($file);
            }
            if(file_exists($dir)){
                deleteDirectory($dir);
            }
            
            die("success:".EAR_PATH."index.php/app?uuid={$uuid}");
        }
    }
}catch(Exception $e){
    if(file_exists($file)){
        unlink($file);
    }
    if(file_exists($dir)){
        deleteDirectory($dir);
    }
    die("Error: ".$e->getMessage());
}


if (!isset($_FILES['appfile']) || !isset($_POST['appdetail']) || !is_json($_POST['appdetail'])) {
    die("Error: File not found");
}
$ext = pathinfo($_FILES['appfile']['name'], PATHINFO_EXTENSION);
if(!in_array($ext, array("apk", "ipa"))){
    die("Error: Invalid Filename");
}
$appdetail = json_decode($_POST['appdetail'], true);

$email = $_SESSION["user"]["email"];
$icon = isset($appdetail["icon"])?trim($appdetail["icon"]):"";
$displayname = isset($appdetail["displayname"])?trim($appdetail["displayname"]):"";
$version = isset($appdetail["version"])?trim($appdetail["version"]):"";
$packagename = isset($appdetail["packagename"])?trim($appdetail["packagename"]):"";
$mnvs = isset($appdetail["mnvs"])?trim($appdetail["mnvs"]):"";
$bid = isset($appdetail["bid"])?trim($appdetail["bid"]):"";
$bsvs = isset($appdetail["bsvs"])?trim($appdetail["bsvs"]):"";
$bvs = isset($appdetail["bvs"])?trim($appdetail["bvs"]):"";

$app = new App();
try{
    if($app->add($email, $_FILES, $icon, $displayname, $version, $packagename, $mnvs, $bid, $bsvs, $bvs)){
        throw new Exception("Upload APP failed");
    }
}catch (Exception $e) {
    die("Error: ".$e->getMessage());
}
