<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
$msg = false;
if(isset($_POST["email"])){
    $email = isset($_POST["email"])?$_POST["email"]:"";
    $passwd = isset($_POST["passwd"])?$_POST["passwd"]:"";
    $admin = new Admin();
    if(
        $email == false || !validateEmail($email) ||
        $passwd == false || strlen($passwd) < 6 ||
        !$admin->login($email, $passwd)
    ){
        $msg = "账号或者密码错误";
    }else{
        
        header("Location: ".EAR_PATH.EAR_SCRIPT."/apps");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="cn" class="light-style customizer-hide" dir="ltr" data-theme="theme-semi-dark" data-template="vertical-menu-template-semi-dark">

  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>管理员登录 | <?php echo esc_html(EAR_NAME);?></title>
    <link rel="icon" type="image/x-icon" href="/favicon.ico" />
    <link rel="stylesheet" href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/css/light.css?v=4.1" />
    <link rel="stylesheet" href="<?php echo EAR_PATH;?>static/index/css/plugins.css?v=7.5" />
  </head>

  <body>
    <div class="authentication-wrapper authentication-cover">
      <div class="authentication-inner row m-0">
        <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center p-5">
          <div class="w-100 d-flex justify-content-center">
            <img src="<?php echo EAR_PATH;?>static/index/image/slider24.png" class="img-fluid">
          </div>
        </div>
        <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg p-sm-5 p-4">
          <div class="w-px-400 mx-auto">
            <h4 class="mb-2">Welcome to <?php echo esc_html(EAR_NAME);?>!</h4>
            <?php if($msg){?>
            <p class="mb-4" style="color:#f44336;">登录失败：<?php echo esc_html($msg);?></p>
            <?php }else{ ?>
            <p class="mb-4">请登录您的账号</p>
            <?php } ?>
            <form id="login_form" class="mb-3" action="" method="POST">
              <div class="mb-3">
                <label for="email" class="form-label">邮箱</label>
                <input type="email" class="form-control notnull" id="email" name="email" title="邮箱" placeholder="输入您的邮箱地址" autofocus>
              </div>
              <div class="form-password-toggle mb-3">
                <div class="d-flex justify-content-between">
                  <label class="form-label" for="passwd">密码</label>
                </div>
                <div class="input-group input-group-merge">
                  <input type="password" id="passwd" class="form-control notnull" name="passwd" title="密码" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" />
                  <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                </div>
              </div>
              <button class="captcha_submit btn btn-primary d-grid w-100" type="submit">登录</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </body>

</html>

