<?php
if (!defined('EAR_ROOT')) {
	die('Access denied');
}
if(!earis_login("admin")){
    header("Location: ".EAR_PATH.EAR_SCRIPT."/login");
    exit;
}

$email = isset($_GET["email"])?trim($_GET["email"]):"";
$sort = isset($_GET["sort"])?intval($_GET["sort"]):1;
$offset = isset($_GET["offset"])?intval($_GET["offset"]):0;
$length = isset($_GET["length"])?intval($_GET["length"]):20;
$appObj = new App();
$apps = $appObj->getApps($email, $sort, $offset, $length);

$title = "应用列表 | ".EAR_NAME;
require_once("header.inc.php");
?>
<div style="padding:1em;">
<?php if($apps == false){ ?>
      <div class="alert alert-light" role="alert" style="margin:2em 0;text-align:center;">无内容</div>
      <?php }else{ ?>
      <table class="table table-hover">
        <thead>
          <tr>
            <th scope="col">#</th>
            <th scope="col">APP名称</th>
            <th scope="col">状态</th>
            <th scope="col">版本</th>
            <th scope="col">大小</th>
            <th scope="col">用户</th>
            <th scope="col">下载数</th>
            <th scope="col">添加时间</th>
            <th scope="col">操作</th>
          </tr>
        </thead>
        <tbody>
          <?php 
        $id = $offset;
        foreach($apps as $path => $app){
            $ext = pathinfo(@$app["filename"], PATHINFO_EXTENSION);
            $uuid = explode("_", basename($path))[1];
            $label = ($ext=="apk")?"android2":(($ext=="ipa")?"apple":"file-earmark-fill");
            echo '<tr>
            <td>'.(++$id).'</td>
            <td class="align-middle" style="text-align:left;">
                <img style="width:1.5em;height:1.5em;border-radius:0.5em;" src="'.esc_html(@$app["icon"]).'" />
                <a style="color:#5e7290;" href="'.esc_html(EAR_PATH.EAR_SCRIPT."/app?uuid=".$uuid).'">'.esc_html($app["displayname"]).'</a>
                <i class="bi-'.esc_html($label).'" style="font-size: 1rem;"></i>
            </td>
            <td>'.(@$app["lock"]==false?'<span class="badge badge-success">已启用</span>':'<span class="badge badge-danger">已禁用</span>').'</td>
            <td class="align-middle">'.esc_html(@$app["version"]).'</td>
            <td class="align-middle">'.esc_html(human_filesize(@$app["size"])).'</td>
            <td class="align-middle"><a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/apps?email=".urlencode($app["email"])).'">'.esc_html(@$app["email"]).'</a></td>
            <td class="align-middle">'.intval(@$app["times2down"]).'</td>
            <td class="align-middle">'.esc_html(date("Y-m-d H:i:s", @$app["addtime"])).'</td>
            <td class="align-middle">
              <a href="'.esc_html(EAR_PATH."app.php/".(@$app["shorturl"]?$app["shorturl"]:$uuid)).'" target="_blank" class="btn btn-light btn-sm" title="浏览">浏览</a>
              <a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/app?uuid=".$uuid).'" class="btn btn-light btn-sm" title="编辑">编辑</a>
              '.(@$app["lock"]==false?'<a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/lockapp?uuid=".$uuid).'" class="btn btn-light btn-sm" title="禁用">禁用</a>':'<a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/unlockapp?uuid=".$uuid).'" class="btn btn-light btn-sm" title="启用">启用</a>').'
              <a href="'.esc_html(EAR_PATH.EAR_SCRIPT."/deleteapp?uuid=".$uuid).'" onclick="javascript:return confirm(\'确定要删除第 '.$id.' 行数据？\');" class="btn btn-danger btn-sm" title="删除">删除</a>
            </td>
          </tr>';
        }
        ?>
        </tbody>
      </table>

      <nav aria-label="Page navigation">
        <ul class="pagination">
          <li class="page-item <?php echo ($offset)?"":"disabled";?>"><a class="page-link" href="<?php echo ($offset)?EAR_PATH.EAR_SCRIPT."/apps?offset=".($offset-$length)."&length={$length}":"#";?>">上一页</a></li>
          <li class="page-item <?php echo (count($apps)<$length)?"disabled":"";?>"><a class="page-link" href="<?php echo ($apps)?EAR_PATH.EAR_SCRIPT."/apps?offset=".($offset+$length)."&length={$length}":"#";?>">下一页</a></li>
        </ul>
      </nav>

      <?php }?>
</div>
<?php require_once("bottom.inc.php");?>

