<?php
require_once("init.php");

if(EAR_INMAINTENANCE){
    echo html_message("维护通知", EAR_MAINTENANCE);
    exit;
}

$path = explode('/', isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '');
$appid = (isset($path[1]) && is_safe_str($path[1]))? $path[1] : "";
$appObj = new App();
$suObj = new ShortURL();

if(stripos($appid, ".plist")){
    $appid = str_replace(".plist", "", $appid);
}

$uuid = $appid;
$app = $appObj->getAPP($uuid);
if($app == false && $suObj->get($appid)){
    $uuid = $suObj->get($appid);
    $app = $appObj->getAPP($uuid);
}
if($app == false){
    header("HTTP/1.1 404 Not Found");
    echo html_message("404", '<center>应用不存在。</center>');
    exit;
}
$ext = pathinfo(@$app["filename"], PATHINFO_EXTENSION);
$filename = ($app["bid"]?$app["bid"]:"app").".{$ext}";
$appfile = $appObj->getAPPFile($uuid);
if($appfile == false || $ext != "ipa"){
    header("HTTP/1.1 404 Not Found");
    echo html_message("404", '<center>应用不存在。</center>');
    exit;
}
$appfile = str_replace(EAR_ROOT.DS, 'https://' . $_SERVER['HTTP_HOST'] . EAR_PATH, $appfile);

header('Content-Description: File Transfer');
header('Content-Type: application/x-plist');
header('Content-Disposition: attachment; filename="'.urlencode($app["bid"].".plist").'"');
echo '<?xml version="1.0" encoding="UTF-8"?><!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">';
?>
<plist version="1.0">
<dict>
	<key>items</key>
	<array>
		<dict>
			<key>assets</key>
			<array>
				<dict>
					<key>kind</key>
					<string>software-package</string>
					<key>url</key>
					<string><![CDATA[<?php echo esc_html($appfile);?>]]></string>
				</dict>
			</array>
			<key>metadata</key>
			<dict>
				<key>bundle-identifier</key>
				<string><?php echo esc_html($app["bid"]);?></string>
				<key>bundle-version</key>
				<string><![CDATA[1.0]]></string>
				<key>kind</key>
				<string>software</string>
				<key>title</key>
				<string><![CDATA[<?php echo esc_html($app["displayname"]);?>]]></string>
			</dict>
		</dict>
	</array>
</dict>
</plist>
