<?php
define('EAR_ROOT', __DIR__);
define("EAR_SCRIPT", trim($_SERVER["SCRIPT_NAME"], "/"));
define("DS", DIRECTORY_SEPARATOR);

if (!file_exists(EAR_ROOT.DS.'data'.DS.'install.lock')) {
	header('Location: ./install.php');
	exit;
}

require_once(EAR_ROOT.DS.'vendor'.DS.'autoload.php');
require_once(EAR_ROOT.DS.'config.php');
foreach(glob(EAR_ROOT.DS.'source'.DS.'system'.DS.'*.php') as $sys_file){
    require_once($sys_file);
}

date_default_timezone_set(EAR_TIMEZONE);
debug_mode();

if(realpath(EAR_DATA) == false){
    echo html_message("系统错误", "数据目录错误");
    exit;
}
if(!is_writable(EAR_DATA)){
    echo html_message("系统错误", "数据目录权限错误");
    exit;
}

if(!is_session_started())
	session_start();
